//
//  XMapClusteringCircle.m
//  Version   : 1.2.5
//  Created by: Xu Liu
//  Email     : me@xuliu.info
//
//  This is one of class for clustering the pins in the MKMapView compoenent for everyone to use
//  under GPL license. When you use this class, please respect the author and keep author's
//  infomation in this class. If you need more information about this class, please visit
//  the website:http://www.xuliu.info/xMapView.html
//

#import "XMapClusteringCircle.h"

@implementation XMapClusteringCircle
-(id)init
{
    self = [super init];
    if(self)
    {
        _drawColor = [UIColor colorWithRed:0 green:0 blue:1 alpha:0.95];
    }
    return self;
}

- (void)drawRect:(CGRect)rect {
    CGFloat lineWidth = 2;
    CGRect borderRect = CGRectInset(rect, lineWidth * 0.5, lineWidth * 0.5);
    CGContextRef context = UIGraphicsGetCurrentContext();
    CGContextSetRGBStrokeColor(context, 0.8, 0.8, 0.8, 1.0);
    CGContextSetFillColorWithColor(context, _drawColor.CGColor);
    CGContextSetLineWidth(context, 2.0);
    CGContextFillEllipseInRect (context, borderRect);
    CGContextStrokeEllipseInRect(context, borderRect);
    CGContextFillPath(context);
}
@end
