//
//  XMapAnnotationView.m
//  Version   : 1.2.5
//  Created by: Xu Liu
//  Email     : me@xuliu.info
//
//  This is one of class for clustering the pins in the MKMapView compoenent for everyone to use
//  under GPL license. When you use this class, please respect the author and keep author's
//  infomation in this class. If you need more information about this class, please visit
//  the website:http://www.xuliu.info/xMapView.html
//

#import "XMapAnnotationView.h"

@implementation XMapAnnotationView
@synthesize uniqueId;
@synthesize pinCategory;
@synthesize iconName;
@synthesize latitude;
@synthesize longitude;
@synthesize pinTag;
@synthesize clustringGroupName;
@synthesize enableMaskColor;
@synthesize iconMaskColor;
@synthesize extraParameters;
@synthesize pinWidth;
@synthesize pinHeight;
@synthesize pinAnchorX;
@synthesize pinAnchorY;
@synthesize enableCustomizedView;
@synthesize customizedView;
@synthesize currentZoomLevel;
@synthesize viwClusteringCircle;
@synthesize labCount;
@synthesize imgViwPin;
@synthesize canBeClustered;
@synthesize periodFlag;
@synthesize iconFontColor;
@synthesize enablePinAnimation;
@synthesize documentPath;
@synthesize bundlePath;

/*
 // Only override drawRect: if you perform custom drawing.
 // An empty implementation adversely affects performance during animation.
 - (void)drawRect:(CGRect)rect {
 // Drawing code
 }
 */


-(id)initWithAnnotation:(id<MKAnnotation>)annotation reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithAnnotation:annotation reuseIdentifier:reuseIdentifier];
    periodFlag = @"";
    iconName = @"";
    latitude = 0;
    longitude = 0;
    int randKey = arc4random() % 10000;//suppose, we have maximun 10000 pins in the map
    uniqueId = [NSString stringWithFormat:@"%f%d",[NSDate timeIntervalSinceReferenceDate],randKey];
    pinTag = @"";
    pinCategory = 0;
    clustringGroupName = @"";
    enableMaskColor = NO;
    pinWidth = 20;
    pinHeight = 30;
    pinAnchorX = 0.5;
    pinAnchorY = 1;
    enableCustomizedView = NO;
    enablePinAnimation = YES;
    iconFontColor = [UIColor blackColor];
    iconMaskColor = [UIColor orangeColor];
    extraParameters = [[NSMutableDictionary alloc] init];
    currentZoomLevel = -1;
    canBeClustered = YES;
    viwClusteringCircle = nil;
    imgViwPin = nil;
    customizedView = nil;
    bundlePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingString:@"/"];
    documentPath = [self getDocumentPath:@""];
    return self;
}


-(void)reloadData{
    //reset the pin for reuse
    if(viwClusteringCircle != nil){
        viwClusteringCircle.hidden = YES;
    }
    
    if(customizedView != nil){
        customizedView.hidden = YES;
    }
    
    if(imgViwPin != nil){
        imgViwPin.hidden = YES;
    }
    
    
    //handle and initialize the pin again
    if(pinCategory == -1)
    {
        //initialize clustering circle
        if(viwClusteringCircle == nil){
            viwClusteringCircle = [[XMapClusteringCircle alloc] initWithFrame:CGRectMake(0, 0, 30, 30)];
            viwClusteringCircle.backgroundColor = [UIColor clearColor];
            viwClusteringCircle.hidden = YES;
            [self addSubview:viwClusteringCircle];
            
            labCount = [[UILabel alloc] initWithFrame:CGRectMake(3, 7, 25, 15)];
            labCount.adjustsFontSizeToFitWidth = YES;
            labCount.font = [UIFont systemFontOfSize:12];
            labCount.textAlignment = NSTextAlignmentCenter;
            [viwClusteringCircle addSubview:labCount];
            [viwClusteringCircle bringSubviewToFront:labCount];
        }
        self.frame = CGRectMake(0, 0, 30, 30);
        self.layer.anchorPoint = CGPointMake(0.5f, 0.5f);
        int iItems = [iconName intValue];
        if(iItems <= 50){
            viwClusteringCircle.frame = CGRectMake(0, 0, 30, 30);
            labCount.frame = CGRectMake(3, 7, 25, 15);
        }else if(iItems > 50 && iItems < 100){
            viwClusteringCircle.frame = CGRectMake(0, 0, 35, 35);
            labCount.frame = CGRectMake(5, 9, 25, 15);
        }else if(iItems >= 100){
            viwClusteringCircle.frame = CGRectMake(0, 0, 40, 40);
            labCount.frame = CGRectMake(8, 12, 25, 15);
        }
        
        viwClusteringCircle.hidden = NO;
        labCount.textColor = iconFontColor;
        viwClusteringCircle.drawColor = iconMaskColor;
        viwClusteringCircle.alpha = 0.8;
        labCount.text = iconName;
    }
    else
    {
        self.frame = CGRectMake(0, 0, pinWidth, pinHeight);
        self.layer.anchorPoint = CGPointMake(pinAnchorX, pinAnchorY);
        
        //use customized pin view
        if(enableCustomizedView){
            if(customizedView != nil){
                customizedView.hidden = NO;
                [self bringSubviewToFront:customizedView];
                [customizedView setNeedsDisplay];
            }
            else{
                NSLog(@"Error: customized pin view is empty,cannot initialize it for the pin.");
            }
        }
        else{
            //show icon rather than customized view
            if(imgViwPin == nil){
                imgViwPin = [[UIImageView alloc] init];
                [self addSubview:imgViwPin];
            }
            
            imgViwPin.frame = CGRectMake(0, 0, pinWidth, pinHeight);
            NSString * documentFolder = [NSString stringWithFormat:@"%@%@",documentPath, iconName];
            if([[NSFileManager defaultManager] fileExistsAtPath:documentFolder]){
                NSData * imgData = [NSData dataWithContentsOfFile:documentFolder];
                if(enableMaskColor){
                    imgViwPin.image = [[UIImage imageWithData:imgData] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
                }
                else{
                    imgViwPin.image = [[UIImage imageWithData:imgData] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
                }
            }
            else{
                //find it in bundle
                NSString * bundleFolder = [NSString stringWithFormat:@"%@%@",bundlePath, iconName];
                NSData * imgData = [NSData dataWithContentsOfFile:bundleFolder];
                if(enableMaskColor){
                    imgViwPin.image = [[UIImage imageWithData:imgData] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
                }
                else{
                    imgViwPin.image = [[UIImage imageWithData:imgData] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
                }
            }
            
            if(enableMaskColor){
                imgViwPin.tintColor = iconMaskColor;
            }
            
            imgViwPin.hidden = NO;
        }
    }
}

-(NSString *)getDocumentPath:(NSString *)fileName
{
    NSArray *paths = NSSearchPathForDirectoriesInDomains
    (NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    NSString *filePath = [NSString stringWithFormat:@"%@/%@",
                          documentsDirectory,fileName];
    
    return filePath;
}

@end
