//
//  XMapAnnotation.m
//  Version   : 1.2.5
//  Created by: Xu Liu
//  Email     : me@xuliu.info
//
//  This is one of class for clustering the pins in the MKMapView compoenent for everyone to use
//  under GPL license. When you use this class, please respect the author and keep author's
//  infomation in this class. If you need more information about this class, please visit
//  the website:http://www.xuliu.info/xMapView.html
//

#import "XMapAnnotation.h"

@implementation XMapAnnotation
@synthesize uniqueId;
@synthesize pinCategory;
@synthesize iconName;
@synthesize latitude;
@synthesize longitude;
@synthesize pinTag;
@synthesize clustringGroupName;
@synthesize enableMaskColor;
@synthesize iconMaskColor;
@synthesize extraParameters;
@synthesize pinWidth;
@synthesize pinHeight;
@synthesize pinAnchorX;
@synthesize pinAnchorY;
@synthesize enableCustomizedView;
@synthesize customizedView;
@synthesize canBeClustered;
@synthesize periodFlag;
@synthesize iconFontColor;
@synthesize enablePinAnimation;
@synthesize documentPath;
@synthesize bundlePath;

-(id)init{
    self = [super init];
    if(self){
        periodFlag = @"";
        iconName = @"";
        latitude = 0;
        longitude = 0;
        int randKey = arc4random() % 10000;//suppose, we have maximun 10000 pins in the map
        uniqueId = [NSString stringWithFormat:@"%f%d",[NSDate timeIntervalSinceReferenceDate],randKey];
        pinTag = @"";
        pinCategory = 0;
        clustringGroupName = @"";
        enableMaskColor = NO;
        canBeClustered = YES;
        pinWidth = 20;
        pinHeight = 30;
        pinAnchorX = 0.5;
        pinAnchorY = 1;
        enableCustomizedView = NO;
        customizedView = nil;
        enablePinAnimation = YES;
        iconFontColor = [UIColor blackColor];
        iconMaskColor = [UIColor orangeColor];
        extraParameters = [[NSMutableDictionary alloc] init];
        bundlePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingString:@"/"];
        documentPath = [self getDocumentPath:@""];
    }
    return self;
}

-(NSString *)getDocumentPath:(NSString *)fileName
{
    NSArray *paths = NSSearchPathForDirectoriesInDomains
    (NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    NSString *filePath = [NSString stringWithFormat:@"%@/%@",
                          documentsDirectory,fileName];
    
    return filePath;
}
@end
