//
//  XAnnotation.m
//  Version   : 1.2.5
//  Created by: Xu Liu
//  Email     : me@xuliu.info
//
//  This is one of class for clustering the pins in the MKMapView compoenent for everyone to use
//  under GPL license. When you use this class, please respect the author and keep author's
//  infomation in this class. If you need more information about this class, please visit
//  the website:http://www.xuliu.info/xMapView.html
//

#import "XAnnotation.h"

@implementation XAnnotation
@synthesize iconName;
@synthesize latitude;
@synthesize longitude;
@synthesize uniqueId;
@synthesize pinTag;
@synthesize clustringGroupName;
@synthesize enableMaskColor;
@synthesize iconMaskColor;
@synthesize extraParameters;
@synthesize pinWidth;
@synthesize pinHeight;
@synthesize pinAnchorX;
@synthesize pinAnchorY;
@synthesize enableCustomizedView;
@synthesize customizedView;
@synthesize canBeClustered;
@synthesize iconFontColor;
@synthesize enablePinAnimation;
@synthesize documentPath;
@synthesize bundlePath;

-(id)init{
    self = [super init];
    if(self){
        iconName = @"";
        latitude = 0;
        longitude = 0;
        uniqueId = [NSString stringWithFormat:@"%f",[NSDate timeIntervalSinceReferenceDate]];
        pinTag = @"";
        clustringGroupName = @"";
        enableMaskColor = NO;
        pinWidth = 20;
        pinHeight = 30;
        pinAnchorX = 0.5;
        pinAnchorY = 1;
        canBeClustered = YES;
        enableCustomizedView = NO;
        customizedView = nil;
        iconFontColor = [UIColor blackColor];
        enablePinAnimation = YES;
        if(arc4random()%4 == 0){iconMaskColor = [UIColor greenColor];}
        else if(arc4random()%4 == 1){iconMaskColor = [UIColor yellowColor];}
        else if(arc4random()%4 == 2){iconMaskColor = [UIColor orangeColor];}
        else if(arc4random()%4 == 3){iconMaskColor = [UIColor magentaColor];}
        else {iconMaskColor = [UIColor redColor];}
        extraParameters = [[NSMutableDictionary alloc] init];
        bundlePath = [[[NSBundle mainBundle] resourcePath] stringByAppendingString:@"/"];
        documentPath = [self getDocumentPath:@""];
    }
    return self;
}

-(NSString *)getDocumentPath:(NSString *)fileName
{
    NSArray *paths = NSSearchPathForDirectoriesInDomains
    (NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    NSString *filePath = [NSString stringWithFormat:@"%@/%@",
                          documentsDirectory,fileName];
    
    return filePath;
}

-(void)updateXAnnotation{
    if(enableCustomizedView){
        if(customizedView != nil){
            [customizedView setNeedsDisplay];
        }
    }
}
@end
