//
//  ViewController.m
//  XSample
//
//  Created by KangKang on 15/4/12.
//  Copyright (c) 2015年 Xu Liu. All rights reserved.
//

#import "ViewController.h"
#import "CustomizedPin.h"

@interface ViewController ()
@property (weak, nonatomic) IBOutlet XMapView *xMapView;

@end

@implementation ViewController
@synthesize xMapView;
@synthesize locationManager;

- (void)viewDidLoad {
    [super viewDidLoad];
    
    //In order to check the sample, please comment the coresponding line
    
    //Example 1: Initialize a single pin
    //[self InitializeSinglePin];
    
    //Example 2: Initialize a lot of pins
    //[self InitializeLotsOfPins];
    
    //Example 3: Ignore Group Name and group all pin, and customized the clustering circle
    //           background color and font color
    //[self ClusteringAllPinsAndIgnoreGroupProperty];
    
    //Example 4: set one group to not to be groupped, and pin has no animation
    //[self OneGroupNotBeGrouped];
    
    //Example 5: set a pin not to be grouped
    //[self OnePinNotBeGrouped];
    
    //Example 6: clustering pins based on different group names
    //           and dynamically hide one group pins
    [self HideOneGroupWhenClustering];
    
    //Example 7: set up your own customized view for the pin
    //[self UsingCustomizedPin];
    
    //Example 8: set up user heading with pin
    //[self UserHeadingWithPins];
    
}

-(void)UserHeadingWithPins
{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    
    //group all pins regardless the group name
    xMapView.ignoreGroupTag = YES;
    
    //step 3 set up user heading and update location
    xMapView.showsUserLocation = YES;
    xMapView.userTrackingMode = MKUserTrackingModeFollowWithHeading;
    locationManager = [[CLLocationManager alloc] init];
    locationManager.delegate = self;
    locationManager.distanceFilter = kCLDistanceFilterNone; //whenever we move
    locationManager.desiredAccuracy = kCLLocationAccuracyBest;
    if([locationManager respondsToSelector:@selector(requestAlwaysAuthorization)]){
        [locationManager requestAlwaysAuthorization];
    }
    [locationManager startUpdatingLocation];
    
    //step 4
    //based on your dataset and create different XAnnotations.
    NSArray * iconNames = @[@"chat.png",@"green.png",@"marker.png"];
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 150; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = [iconNames objectAtIndex:arc4random()%3];     //set up pin's icon randomly
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 5
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 6
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
    
    [xMapView reloadAnnotationsInMap];

}


-(void)UsingCustomizedPin{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    
    //step 3
    //based on your dataset and create customized view.
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 20; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        CustomizedPin * customizedView = [[CustomizedPin alloc] initWithFrame:CGRectMake(0, 0, 100, 40)];
        customizedView.backgroundColor = [UIColor clearColor];
        
        pin.enableCustomizedView = YES;
        pin.customizedView = customizedView;
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 5
    //refresh map to hide the orange.png group
    [xMapView refreshAnnotationsInMap];
    
    //step 6
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

-(void)HideOneGroupWhenClustering
{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    
    //step 3
    //based on your dataset and create different XAnnotations.
    NSArray * iconNames = @[@"chat.png",@"green.png",@"marker.png",@"orange.png"];
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 150; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = [iconNames objectAtIndex:arc4random()%4];     //set up pin's icon randomly
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 5 set up the group name that don't want to show in the map
    [xMapView.needToHideGroups addObject:@"orange.png"];
    
    //step 6
    //refresh map to hide the orange.png group
    [xMapView refreshAnnotationsInMap];
    
    //step 7
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

-(void)OnePinNotBeGrouped
{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    
    //group all pins regardless the group name
    xMapView.ignoreGroupTag = YES;
    
    
    //step 3
    //based on your dataset and create different XAnnotations.
    NSArray * iconNames = @[@"chat.png",@"green.png",@"marker.png"];
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 150; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = [iconNames objectAtIndex:arc4random()%3];     //set up pin's icon randomly
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 5 set up a separetly one pin to not be grouped

    XAnnotation * pin = [[XAnnotation alloc] init];
    
    //set up pin's latitude randomly
    pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
    
    //set up pin's longitude randomly
    pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
    
    pin.iconName = @"orange.png";     //set up pin's icon randomly
    
    pin.pinWidth = 35;              //set up pin's width and height,
    pin.pinHeight = 35;             //image will automatically scale
    
    pin.pinAnchorX = 0.5;           //set up the center of the image
    pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
    //pin location
    
    pin.canBeClustered = NO;        //set up this group can not be grouped
    
    pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
    //automatically cluster the pin in the same group
    //name
    
    //step 6
    //add new pins into the map
    [xMapView addXAnnotation:pin];
    
    //step 7
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

-(void)OneGroupNotBeGrouped{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    
    //group all pins regardless the group name
    xMapView.ignoreGroupTag = YES;
    
    
    //step 3
    //based on your dataset and create different XAnnotations.
    NSArray * iconNames = @[@"chat.png",@"green.png",@"marker.png"];
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 150; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = [iconNames objectAtIndex:arc4random()%3];     //set up pin's icon randomly
        
        //specify chat.png group has no pin animation
        //by default, pin animation is enabled
        pin.enablePinAnimation = NO;
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 5 set up a separetly group to not be grouped
    [pins removeAllObjects];
    for(int i = 0; i < 50; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = @"orange.png";     //set up pin's icon randomly
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
                                        //pin location
        
        pin.canBeClustered = NO;        //set up this group can not be grouped
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 6
    //add new pins into the map
    [xMapView addXAnnotations:pins];
    
    //step 7
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

-(void)ClusteringAllPinsAndIgnoreGroupProperty
{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    
    //group all pins regardless the group name
    xMapView.ignoreGroupTag = YES;
    
    
    //step 3
    //based on your dataset and create different XAnnotations.
    NSArray * iconNames = @[@"chat.png",@"green.png",@"marker.png",@"orange.png"];
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 200; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = [iconNames objectAtIndex:arc4random()%4];     //set up pin's icon randomly
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        //set up the group circle background and font color
        pin.iconFontColor = [UIColor whiteColor];
        pin.iconMaskColor = [UIColor colorWithRed:0.5 green:0 blue:0 alpha:0.5];
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 5
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

-(void)InitializeLotsOfPins
{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 80;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    
    //step 3
    //based on your dataset and create different XAnnotations.
    NSArray * iconNames = @[@"chat.png",@"green.png",@"marker.png",@"orange.png"];
    NSMutableArray * pins = [[NSMutableArray alloc] init];
    for(int i = 0; i < 200; i++)
    {
        XAnnotation * pin = [[XAnnotation alloc] init];
        
        //set up pin's latitude randomly
        pin.latitude = 43.719880 + (arc4random()%1000) * 0.0001;
        
        //set up pin's longitude randomly
        pin.longitude = -79.467060 + (arc4random()%1000) * 0.0001;
        
        pin.iconName = [iconNames objectAtIndex:arc4random()%4];     //set up pin's icon randomly
        
        pin.pinWidth = 35;              //set up pin's width and height,
        pin.pinHeight = 35;             //image will automatically scale
        
        pin.pinAnchorX = 0.5;           //set up the center of the image
        pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
        //pin location
        
        pin.clustringGroupName = pin.iconName;//set up the group name. XMapView will
        //automatically cluster the pin in the same group
        //name
        
        [pins addObject:pin];
    }
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotations:pins];
    
    //step 5
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

-(void)InitializeSinglePin
{
    //step 1
    //initialize the mapview,once it is initialized, do not need to initialize it again
    [xMapView initialize];
    
    //step 2
    //set up related parameters for XMapView
    xMapView.clusteringGroupNrofPins = 5;   //set up the number of group
    //that means, after 5 pins in a group
    //XMapView will start to cluster them
    
    xMapView.clusteringRadius = 30;         //set up the radius for a set of pins
    //in a screen the unit for this
    //one is pixels compare to screen resolution.
    
    xMapView.enableClusteringRadiusAutoAdjust = NO;
    //by default, auto radius is enabled
    //it indicates XMapView to cluster pins
    //based on Map Zoom Level
    
    //step 3
    //based on your dataset and create XAnnotation. each XAnnotation is a pin in the map
    XAnnotation * pin = [[XAnnotation alloc] init];
    pin.latitude = 43.719880;       //set up pin's latitude
    pin.longitude = -79.467060;     //set up pin's longitude
    pin.iconName = @"chat.png";     //set up pin's icon
    
    pin.pinWidth = 35;              //set up pin's width and height,
    pin.pinHeight = 35;             //image will automatically scale
    
    pin.pinAnchorX = 0.5;           //set up the center of the image
    pin.pinAnchorY = 1;             //currently, the image middle bottom will be the
    //pin location
    
    pin.clustringGroupName = @"chat";//set up the group name. XMapView will
    //automatically cluster the pin in the same group
    //name
    
    //step 4
    //add pin in the map
    [xMapView addXAnnotation:pin];
    
    //step 5
    //located to this pin
    [xMapView setRegion:MKCoordinateRegionMake(CLLocationCoordinate2DMake(43.719880, -79.467060), MKCoordinateSpanMake(0.25, 0.25))];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


//for example 8
- (void)xmapView:(MKMapView *)mapView didUpdateUserLocation:(MKUserLocation *)userLocation{
    NSLog(@"aaa");
    [mapView setCenterCoordinate:userLocation.location.coordinate animated:YES];
}

@end
