//
//  CustomizedPin.m
//  XSample
//
//  Created by KangKang on 15/4/25.
//  Copyright (c) 2015年 Xu Liu. All rights reserved.
//

#import "CustomizedPin.h"

@implementation CustomizedPin
@synthesize customizedLabel;

-(id)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if(self){
        //define your customized elements here
        customizedLabel = [[UILabel alloc] initWithFrame:frame];
        customizedLabel.text = @"customized label";
        customizedLabel.adjustsFontSizeToFitWidth = YES;
        customizedLabel.font = [UIFont systemFontOfSize:10];
        customizedLabel.textAlignment = NSTextAlignmentCenter;
        customizedLabel.backgroundColor = [UIColor orangeColor];
        customizedLabel.numberOfLines = 2;
        [self addSubview:customizedLabel];
        
        //set up the customized view style
        self.layer.cornerRadius = 8;
        self.layer.borderColor = [UIColor whiteColor].CGColor;
        self.layer.borderWidth = 2;
        self.layer.shadowOpacity = 0.8;
        self.layer.shadowColor = [UIColor blackColor].CGColor;
        self.layer.shadowOffset = CGSizeMake(3, 3);
        self.layer.shadowRadius = 5;
        self.clipsToBounds = YES;
    }
    return self;
}
@end
